// This file was generated by Dashcode from Apple Computer, Inc.
// and modified by Prateek Rungta http://prateekrungta.com/livescorewidget


function load()
{
	setupParts();
	setHandlers();
	hideElement("refreshButton");
	hideElement("backButton");
	hideElement("forwardButton");
}

function remove()
{
	// your widget has just been removed from the layer
	// remove any preferences as needed
	// widget.setPreferenceForKey(null, createInstancePreferenceKey("your-key"));
}

function hide()
{
	// your widget has just been hidden stop any timers to
	// prevent cpu usage
	
	if (refreshTimer) {
		clearInterval(refreshTimer);
		refreshTimer = null;
	}
}

function show()
{
	// the widget has just been shown.  restarting any timers
	// and adjusting the interface as needed
	
	refreshContent();	//gets the scores from the google.co.in server
	checkForUpdate();	//checks for widget updates
}

function showBack(event)
{
	// your widget needs to show the back

	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToBack");

	front.style.display="none";
	back.style.display="block";
	
	if (window.widget)
		setTimeout('widget.performTransition();', 0);
}

function showFront(event)
{
	// your widget needs to show the front

	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToFront");

	front.style.display="block";
	back.style.display="none";
	
	if (window.widget)
		setTimeout('widget.performTransition();', 0);
}

if (window.widget)
{
	widget.onremove = remove;
	widget.onhide = hide;
	widget.onshow = show;
}

function showElement(elementId)
{
	var element = document.getElementById(elementId);
	if (element) {
		element.style.display = "block";
	}
}

function hideElement(elementId)
{
	var element = document.getElementById(elementId);
	if (element) {
		element.style.display = "none";
	}
}

function elementDisplayState(elementId)
{
	var element = document.getElementById(elementId);
	if (element) {
		return (element.style.display == "none") ? "none" : "block";
	}
	return "none";
}

function setHandlers()
{
	var backOver = new Image();
	backOver.src = "Images/backButton_over.png";
	var backDown = new Image();
	backDown.src = "Images/backButton_down.png";
	var forwardOver = new Image();
	forwardOver.src = "Images/forwardButton_over.png";
	var forwardDown = new Image();
	forwardDown.src = "Images/forwardButton_down.png";

	var backButton = document.getElementById("backButton");
	if (backButton) {
		addHilightListeners(backButton, backOver, backDown);
	}

	var forwardButton = document.getElementById("forwardButton");
	if (forwardButton) {
		addHilightListeners(forwardButton, forwardOver, forwardDown);
	}
}

function addHilightListeners(element, overImage, downImage)
{
	var offImage = new Image();
	offImage.src = element.src;

	element.addEventListener("mouseover", function () { swapImage(element, overImage) }, true);
	element.addEventListener("mousedown", function () { swapImage(element, downImage) }, true);
	element.addEventListener("mouseup", function () { swapImage(element, overImage) }, true);
	element.addEventListener("mouseout", function () { swapImage(element, offImage) }, true);
}

function swapImage(element, image)
{
	element.src = image.src;
}

function showNextMatch(event)
{
	var activeMatch = findMatchIndex(currentMatch);
	if (activeMatch >= matches.length-1 || activeMatch == -1) {
		currentMatch = matches[0].matchId;
	} else {
		currentMatch = matches[activeMatch+1].matchId;
	}
	showMatch();
}

function showPreviousMatch(event)
{
	var activeMatch = findMatchIndex(currentMatch);
	if (activeMatch <= 0) {
		currentMatch = matches[0].matchId;
	} else {
		currentMatch = matches[activeMatch-1].matchId;
	}
	showMatch();
}

function openDonateUrl(event) 
{
	widget.openURL(donateURL);
}


function refreshButton(event) 
{
	refreshContent();
}


function goToCricinfo(event) 
{
	widget.openURL("http://cricinfo.com");
}


function goToGoogleCricket(event) 
{
	widget.openURL("http://www.google.co.in/cricket");
}


function homePage(event) 
{
	widget.openURL(cricketScoreURL);
}


function updateVersion(event) 
{
	hideUpdateSlider();
	widget.openURL(cricketScoreURL);
}


function ignoreVersion(event) 
{
	hideUpdateSlider();
	widget.setPreferenceForKey(latestVersion, "ignoredVersion");
}


function analyseKey(event) 
{
	var state = elementDisplayState("front");
	if (window.widget &&  state == "block") {
		key = event.which;
		if (key == 63235 && elementDisplayState("forwardButton") == "block") showNextMatch(event);
		else if (key == 63234 && elementDisplayState("backButton") == "block") showPreviousMatch(event);
		else if (key == 114) refreshContent();
		else if (key == 117) getLatestVersion();
	}
}
